// LANDlg.cpp : implementation file
//

#include "stdafx.h"
#include "LAN.h"
#include "LANDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include <winsock2.h>
#include "MyFunc.h"
#include "JsPrinterDll.h"
#pragma comment(lib, "JsPrinterDll")
#pragma comment(lib, "ws2_32.lib")
/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLANDlg dialog

CLANDlg::CLANDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CLANDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLANDlg)
	bHex = FALSE;
	m_strTx = _T("Welcome to use the impact and thermal printer manufactured by professional POS receipt printer company!\n");
	iPrintNum = 1;
	NetPortSocket=INVALID_SOCKET;
	PrinterAddr.sin_family=AF_INET;
	PrinterAddr.sin_port=htons(9100);//ӡӶ˿Ϊ9100
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CLANDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLANDlg)
	DDX_Control(pDX, IDC_IPADDRESS_PRINT_IP, m_PriIp);
	DDX_Control(pDX, IDC_IPADDRESS_LOCAL_IP, m_LocalIP);
	DDX_Check(pDX, IDC_CHECK_HEX, bHex);
	DDX_Text(pDX, IDC_EDIT_TX, m_strTx);
	DDX_Text(pDX, IDC_EDIT_PRINTNUM, iPrintNum);
	DDV_MinMaxInt(pDX, iPrintNum, 1, 1000);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CLANDlg, CDialog)
	//{{AFX_MSG_MAP(CLANDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_ADD, OnButtonAdd)
	ON_BN_CLICKED(IDC_BUTTON_JIAN, OnButtonJian)
	ON_BN_CLICKED(IDC_BUTTON_CLR, OnButtonClr)
	ON_BN_CLICKED(IDC_BUTTON_PRINT, OnButtonPrint)
	ON_BN_CLICKED(IDC_BUTTON_REFRESH, OnButtonRefresh)
	ON_BN_CLICKED(IDC_BUTTON5, OnButtonConnect)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLANDlg message handlers

BOOL CLANDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	InitNetSev();  //
	DWORD dwLocalIp;
	GetHostName(&dwLocalIp);  //ȡIP
	m_LocalIP.SetAddress(dwLocalIp);
	m_PriIp.SetAddress((char)192,(char)168,(char)123,(char)100);  
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CLANDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CLANDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CLANDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CLANDlg::OnButtonAdd() 
{
	// TODO: Add your control notification handler code here
	iPrintNum++;
	UpdateData(FALSE);
}


void CLANDlg::OnButtonJian() 
{
	// TODO: Add your control notification handler code here
	iPrintNum--;
	if(iPrintNum<=0)
	{
		iPrintNum=1;
	}
	UpdateData(FALSE);
}

void CLANDlg::OnButtonClr() 
{
	// TODO: Add your control notification handler code here
	m_strTx.Empty();
	UpdateData(FALSE);
}


extern int String2Hex(char *SendStr, char *SendHex);
void CLANDlg::OnButtonPrint() 
{
	// TODO: Add your control notification handler code here
	if(NetPortSocket==INVALID_SOCKET)
	{
		AfxMessageBox("Not connected or failed to connect!");
		return;
	}
	UpdateData(TRUE);
	if(m_strTx.GetLength()==0)
	{
		AfxMessageBox("Send data is empty!");
		return ;
	}

	char *sendbuf;
    sendbuf=(LPTSTR)(LPCTSTR)m_strTx;
	DWORD Bytes=strlen(sendbuf);

	if(bHex==1)  //ʮƷ
	{
		char *SendHex=new char[Bytes/2];
		DWORD HexLength;
		HexLength=String2Hex(sendbuf,SendHex);
		if(HexLength==0)
		{
			AfxMessageBox(_T("Character input is incorrect"));
			return;
		}
		int iResult=WriteToNetPort(&NetPortSocket,//ѽӵ׽ַ
			SendHex,        //ݵĻ 
			HexLength);			//ȡ 
		if(iResult==SOCKET_ERROR)	//SOCKET_ERROR=-1;
		{
			AfxMessageBox("Sending data failed!");
		}
		else
		{
			//AfxMessageBox("Send data successfully !");
		}
		delete[] SendHex;
	}
	else
	{
		int i=iPrintNum;       //ӡ
		while(i--)
		{
			if(WriteToNetPort(&NetPortSocket,sendbuf,Bytes)==-1)  
			{
				AfxMessageBox(_T("Write failed!"));
				CloseNetPor(&NetPortSocket);
				break;
			}
		}//end while 
	}
}

void CLANDlg::OnButtonRefresh() //ˢIP
{
	// TODO: Add your control notification handler code here
	DWORD dwLocalIp;
	GetHostName(&dwLocalIp);
	m_LocalIP.SetAddress(dwLocalIp);
}



void CLANDlg::OnButtonConnect()		//Ӳ
{
	// TODO: Add your control notification handler code here
	CloseNetPor(&NetPortSocket);				//ر֮ǰ򿪵׽
	SetCursor(LoadCursor(NULL,   IDC_WAIT));    //ȴ
	UpdateData(TRUE);

	DWORD dwTemp;
	m_PriIp.GetAddress(dwTemp); //ȡIPؼĵַ
	PrinterAddr.sin_addr.S_un.S_addr=htonl(dwTemp); 

	timeval timeout;		//ӳʱ
	timeout.tv_sec = 1;     //1
	timeout.tv_usec =0;     //0΢

	int iRet=0;
	iRet=ConnectNetPort(&NetPortSocket,	  //׽
		&PrinterAddr,					  //ӡַ
		&timeout );						  //ʱ
	if(iRet==-1)
	{
		AfxMessageBox("Failed to create socket",MB_ICONINFORMATION);
		return ;
	}
	if(iRet==-2)
	{
		AfxMessageBox("Set to block mode error",MB_ICONINFORMATION);
		return ;
	}
	if(iRet==-3)
	{
		AfxMessageBox("The connection timed out, make sure the printer is properly connected",MB_ICONINFORMATION);
		return ;
	}
	if(iRet==1)
	{
		AfxMessageBox("connection succeeded",MB_ICONINFORMATION);
	}
}


BOOL CLANDlg::DestroyWindow() 
{
	// TODO: Add your specialized code here and/or call the base class
	CloseNetPor(&NetPortSocket);   //ر׽
	CloseNetServ();   //ر
	return CDialog::DestroyWindow();
}

void CLANDlg::OnOK()//OnOk()
{
	
}